<?php
/*======================================================================*\
|| #################################################################### ||
|| # v3 Arcade for vBulletin                                          # ||
|| # Support: http://www.v3arcade.com                                 # ||
|| # Copyright: http://www.cinvin.com                                 # ||
|| #################################################################### ||
\*======================================================================*/

// ##### file_put_contents for PHP4 ###########################################
if (!function_exists('file_put_contents'))
{
	function file_put_contents($filepath, $resource)
	{
		if (!$resource)
		{
			return false;
		}
		
		if ($fp = fopen($filepath, 'wb'))
		{
			fputs($fp, $resource, strlen($resource));
			fclose($fp);
		}
	}
}

// ##### Fetch Cateogry Options ###############################################
function fetch_arcade_cats($opts = array())
{
	global $db;

	$getcats = $db->query_read("
		SELECT categoryid, catname
		FROM " . TABLE_PREFIX . "v3arcade_categories
		WHERE categoryid != 2
		ORDER BY displayorder ASC
	");
	while ($cat = $db->fetch_array($getcats))
	{
		$opts[$cat['categoryid']] = $cat['catname'];
	}

	return $opts;
}

// ##### Print a pretty Javascript dot picture ################################
function print_dots_start_arcade($text, $dotschar = ':', $elementid = 'dotsarea')
{
	if (defined('NO_IMPORT_DOTS'))
	{
		return;
	}

	?>
<p align="center"><?php echo $text; ?><br /><br />[<span style="color:yellow; font-weight:bold" id="<?php echo $elementid; ?>"><?php echo $dotschar; ?></span>]</p>
<script type="text/javascript">
<!--
function js_dots()
{
	elObj = document.getElementById('<?php echo $elementid; ?>');
	elObj.innerHTML = elObj.innerHTML + "<?php echo $dotschar; ?>";
	jstimer = setTimeout("js_dots();", 75);
}

js_dots();

//-->
</script>
	<?php

	vbflush();
}

function print_dots_stop_arcade($elementid = 'dotsarea')
{
	if (defined('NO_IMPORT_DOTS'))
	{
		return;
	}

	vbflush();
	?>
<script type="text/javascript">
<!--

clearTimeout(jstimer);
document.getElementById('<?php echo $elementid; ?>').innerHTML = "<?php echo $vbphrase['done'] ?>";

//-->
</script>
	<?php

	vbflush();
}

// ##### Recursively remove a directory #######################################
function delete_directory($dirname)
{
	if (is_dir($dirname))
	{
		$dir_handle = opendir($dirname);
	}

	if (!$dir_handle)
	{
		return false;
	}

	while($file = readdir($dir_handle))
	{
		if ($file != '.' && $file != '..')
		{
			if (!is_dir($dirname . '/' . $file))
			{
				@chmod($dirname . '/' . $file, 0777);
				@unlink($dirname . '/' . $file);
			} else {
				delete_directory($dirname . '/' . $file);
			}
		}
	}
	closedir($dir_handle);
	@chmod($dirname, 0777);
	@rmdir($dirname);
	return true;
}

// ##### Update Category Cache ################################################
function build_cat_cache()
{
	global $db;

	$cache = array();
	$getcats = $db->query_read("
		SELECT categoryid, catname
		FROM " . TABLE_PREFIX . "v3arcade_categories
		WHERE isactive = 1
		ORDER BY displayorder ASC
	");
	while ($cat = $db->fetch_array($getcats))
	{
		$cache[$cat['categoryid']] = $cat['catname'];
	}

	build_datastore('v3a_cats', serialize($cache), 1);
}

// ##### Build Games ##########################################################
function build_games($rebuild = 0)
{
	global $db, $vbulletin;

	$gamecache = array();

	// Cache games.
	$games = $db->query("SELECT * FROM " . TABLE_PREFIX . "v3arcade_games");
	while ($game = $db->fetch_array($games))
	{
		$gamecache[$game['gameid']] = $game;
	}

	// just incase...
	if (empty($gamecache))
	{
		return false;
	}

	$processed = array();
	$sessioncounts = $db->query_read("
		SELECT arcade_sessions.gameid, COUNT(*) AS sessioncount, arcade_games.isreverse
		FROM " . TABLE_PREFIX . "v3arcade_sessions AS arcade_sessions
		LEFT JOIN " . TABLE_PREFIX . "v3arcade_games AS arcade_games ON (arcade_games.gameid = arcade_sessions.gameid)
		WHERE arcade_sessions.valid = 1
		GROUP BY arcade_sessions.gameid
	");
	while ($gamesession = $db->fetch_array($sessioncounts))
	{
		$processed[] = $gamesession['gameid'];

		if ($rebuild OR ($gamesession['sessioncount'] != $gamecache[$gamesession['gameid']]['sessioncount']))
		{
			// Sessioncount mismatch, recalculate high scorer.
			if ($champcheck = $db->query_first("
				SELECT userid, score
				FROM " . TABLE_PREFIX . "v3arcade_sessions AS arcade_sessions
				WHERE valid = 1
					AND gameid = $gamesession[gameid]
				ORDER BY score " . ($gamesession['isreverse'] ? 'ASC' : 'DESC') . ", finish DESC
			"))
			{
				$newchampsql = ", highscorerid = $champcheck[userid], highscore = '$champcheck[score]'";
			}

			$db->query_write("
				UPDATE " . TABLE_PREFIX . "v3arcade_games SET
					sessioncount = " . $gamesession['sessioncount'] . "
					$newchampsql
				WHERE gameid = " . $gamesession['gameid']
			);
		}
	}

	// reset to 0 if there is no champ found above
	if (!empty($processed))
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "v3arcade_games SET
				sessioncount = 0,
				highscorerid = 0,
				highscore = 0
			WHERE gameid NOT IN(" . implode(', ', $processed) . ")
		");
	}
}

// ##### Cache Games ##########################################################
function cache_games()
{
	global $db;

	$cache = array();
	$getgames = $db->query_read("
		SELECT shortname, title
		FROM " . TABLE_PREFIX . "v3arcade_games
	");
	while ($game = $db->fetch_array($getgames))
	{
		$cache[$game['shortname']] = $game['title'];
	}

	return $cache;
}

// ##### Insert New Game ######################################################
function insert_v3a_game($game)
{
	global $db, $vbphrase;
	
	$db->query_write(fetch_query_sql($game, 'v3arcade_games'));

	($hook = vBulletinHook::fetch_hook('arcade_functions_insert_v3a_game')) ? eval($hook) : false;

	insert_arcade_news(construct_phrase(
			$vbphrase['news_game_has_been_added'],
			$game['title'])
	);

	return construct_phrase($vbphrase['installed_x'], $game['title']) . '<br />';;
}

?>